ORCA/M Asm65816 2.1.0

0001 B62B                       title 'NewControl2' 
0002 B62B              **********************************************************************
0003 B62B              *           Copyright Apple Computer, Inc. 1986-88
0004 B62B              *                    All rights reserved
0005 B62B              *
0006 B62B              * NewControl2
0007 B62B              *
0008 B62B              *
0009 B62B              * 23 Sep 88         David Good
0010 B62B              *
0011 B62B              * First Pass
0012 B62B              *
0013 B62B              * 24 Sep 88         Steven Glass
0014 B62B              *
0015 B62B              * Integration and first debugging.
0016 B62B              *
0017 B62B              * 28 Sep 88         Steven Glass
0018 B62B              *
0019 B62B              * Change in the way that the recsize routines can use the param
0020 B62B              * field.  If the routines are called by NewControl, param is zero.
0021 B62B              * If the routines are called by NewControl2, param is pointer to
0022 B62B              * template.
0023 B62B              *
0024 B62B              * 7 Oct 88          Steven Glass
0025 B62B              *
0026 B62B              * Used common load and release resource routines and don't worry
0027 B62B              * about errors.
0028 B62B              *
0029 B62B              * 10 Oct 88         Steven Glass
0030 B62B              *
0031 B62B              * Changed the way the temporary work area was used.  Using it for
0032 B62B              * local variables was ok until I created a scroll control.  So I
0033 B62B              * now have some more data in the global data area, and all references
0034 B62B              * to it are indirect.  TemplatePtr is now at yRat since the mouse 
0035 B62B              * position is not used during new control.
0036 B62B              *
0037 B62B              **********************************************************************
0038 B62B                       Blanks off 
0039 B62B                       String asis 
0040 B62B
0041 B62B
0042 B62B                       print push 
0043 B62B                       print off 
0044 B62B
0045 B62B                       INCLUDE 'all.macros' 
0046 B62B                       Include 'Special.macros' 
0047 B62B                       INCLUDE 'equates.asm' 
0048 B62B                       include 'SuperEquates.asm' 
0049 B62B
0050 B62B                       IMPORT  CMpop10bytes 
0051 B62B                       print pop 
0052 B62B
0053 B62B
0054 B62B              **********************************************************************
0055 B62B              *
0056 B62B              * Variables used by NewControl2 and subroutines.
0057 B62B              *
0058 B62B              **********************************************************************
0059 B62B                       DSECT Inputs 
0060 B62B              InputRef long                           ;these are passed to us on the stack
0061 B62B              InputVerb word 
0062 B62B              TheWindow long 
0063 B62B              ResultH  long 
0064 B62B
0065 B62B
0066 B62B              TemplatePtr equ yRat                    ; this is not used at init time.
0067 B62B
0068 B62B
0069 B62B
0070 B62B                       title 'NewControl2' 
0071 B62B              ****************************************************************
0072 B62B              *
0073 B62B              NewControl2 PROC  EXPORT 
0074 B62B              *
0075 B62B              * This is a new way to create one or more controls. Instead of
0076 B62B              * passing all the information on the stack we pass a reference
0077 B62B              * to an input record and a "verb" that describes what kind of
0078 B62B              * reference we passed
0079 B62B              *
0080 B62B              * Inputs:
0081 B62B              *                   Space For Result    LONG
0082 B62B              *                   OwnerPtr            LONG
0083 B62B              *                   InputVerb           WORD
0084 B62B              *                   InputRef            LONG
0085 B62B              *
0086 B62B              * Outputs:
0087 B62B              *                   Control Handle      LONG
0088 B62B              *
0089 B62B              * External Refs:
0090 B62B                       import LoadResource 
0091 B62B                       import ReleaseResource 
0092 B62B              *
0093 B62B              * Entry Points:
0094 B62B              *                   none
0095 B62B              *
0096 B62B                       longa on                       ; mode
0097 B62B                       longi on 
0098 B62B              *
0099 B62B              ****************************************************************
0100 B62B
0101 B62B
0102 B62B
0103 B62B 20 15 A0              jsr   CMStartup                ;link things in and start things up.
0104 B62E
0105 B62E A6 56                 ldx   TheWindow+2              ;use the window pointer
0106 B630 A5 54                 lda   TheWindow
0107 B632 20 C1 A1              jsr   makeWptr                 ;windptr = pointer to window.
0108 B635
0109 B635              ;-----------------------------------------------------------
0110 B635              ;
0111 B635              ; zero out the saved resourceid, savedhandle and 
0112 B635              ; the errorcode in global data.
0113 B635              ;
0114 B635 A9 00 00              lda   #0
0115 B638 A0 8C 00              ldy   #SavedRescID
0116 B63B 97 41        @ZeroLoop sta   [Data],y
0117 B63D C8                    iny   
0118 B63E C8                    iny   
0119 B63F C0 96 00              cpy   #ErrorCode+2
0120 B642 90 F7                 bcc   @ZeroLoop
0121 B644
0122 B644 64 58 64 5A           stzl ResultH                   ;zero out the returned value
0123 B648
0124 B648 A5 52                 lda   InputVerb                ;use the verb as an index into the startup
0125 B64A 0A                    asl   a                        ;..table. These routines convert the
0126 B64B AA                    tax                            ;..InputRef to a pointer
0127 B64C 7C 80 B7              jmp   (startupTable,x)
0128 B64F
0129 B64F
0130 B64F              ;-----------------------------------------------------------
0131 B64F              ;
0132 B64F              ; This is the code that is run when the input is some
0133 B64F              ; kind of resource.
0134 B64F              ;
0135 B64F              rescStartup  
0136 B64F A0 8C 00              ldy   #SavedRescID             ; save the resource id
0137 B652 A5 4E                 lda   InputRef
0138 B654 97 41                 sta   [data],y
0139 B656 C8                    iny   
0140 B657 C8                    iny   
0141 B658 A5 50                 lda   InputRef+2
0142 B65A 97 41                 sta   [data],y
0143 B65C
0144 B65C 48 48                 PushLongSpace                  ;space for the returned handle
0145 B65E A5 52                 lda   InputVerb                ;check to see if we are loading a list
0146 B660 C9 09 00              cmp   #resourceToResource      ;..resource or a template resource...
0147 B663 F0 05                 beq   @multiple
0148 B665 F4 04 80              PushWord #rControlTemplate 
0149 B668 80 03                 bra   @single
0150 B66A F4 03 80     @multiple PushWord #rControlList 
0151 B66D D4 50 D4 4E  @single  PushZLong InputRef 
0152 B671 20 9C 9D              jsr   LoadResource             ;load the resource and clobber the
0153 B674 68 85 4E 68           PullLong InputRef              ;..InputRef. (now it's a handle)
0154 B67A
0155 B67A
0156 B67A
0157 B67A
0158 B67A              ;-----------------------------------------------------------
0159 B67A              ;
0160 B67A              ; This is the code that is run when the input is some kind
0161 B67A              ; of handle.  Note that the resource code falls in here.
0162 B67A              ;
0163 B67A              handStartup  
0164 B67A A0 90 00              ldy   #SavedHandle             ; save the resource handle
0165 B67D A5 4E                 lda   InputRef
0166 B67F 97 41                 sta   [data],y
0167 B681 C8                    iny   
0168 B682 C8                    iny   
0169 B683 A5 50                 lda   InputRef+2
0170 B685 97 41                 sta   [data],y
0171 B687
0172 B687 A0 04 00              ldy   #4                       ;lock and dereference the input handle
0173 B68A B7 4E                 lda   [InputRef],y             ;(note: bit manipulation is legal now !)
0174 B68C 09 00 80              ora   #$8000
0175 B68F 97 4E                 sta   [InputRef],y
0176 B691 88                    dey   
0177 B692 88                    dey   
0178 B693 B7 4E                 lda   [InputRef],y
0179 B695 AA                    tax   
0180 B696 A7 4E                 lda   [InputRef]               ;store the new pointer back over the
0181 B698 85 4E 86 50           stax InputRef                  ;..InputRef and fall thru to pointer
0182 B69C
0183 B69C
0184 B69C              ;-----------------------------------------------------------
0185 B69C              ;
0186 B69C              ; This is the code that is run when the input is some kind
0187 B69C              ; of pointer.  Note that the handle and resource code fall
0188 B69C              ; in here.
0189 B69C              ;
0190 B69C              ptrStartup  
0191 B69C A0 00 00              ldy   #0                       ;all the action routines use Y as a index
0192 B69F A5 52                 lda   InputVerb                ;..into the list.
0193 B6A1 0A                    asl   a
0194 B6A2 AA                    tax   
0195 B6A3 7C 94 B7              jmp   (actionTable,x)
0196 B6A6
0197 B6A6
0198 B6A6
0199 B6A6
0200 B6A6
0201 B6A6              ;-----------------------------------------------------------
0202 B6A6              ;
0203 B6A6              ; Make a control for each pointer in the list.
0204 B6A6              ;
0205 B6A6 20 A8 B7     ptrLoop  jsr   FillTemplatePtr          ;get the next template pointer (use Y as
0206 B6A9 90 03                 bcc   @Cont
0207 B6AB 82 86 00              brl   cleanup                  ; if there are no more we are done.
0208 B6AE              @cont     
0209 B6AE 5A                    phy                            ;..the index) - save the index
0210 B6AF 20 D2 B7              jsr   MakeControl              ;create the control using TemplatePtr
0211 B6B2 A0 94 00              ldy   #ErrorCode
0212 B6B5 B7 41                 lda   [data],y
0213 B6B7 7A                    ply                            ;restore the index
0214 B6B8 C9 00 00              cmp   #0                       ;check for errors
0215 B6BB F0 E9                 beq   ptrLoop
0216 B6BD 80 75                 bra   cleanup
0217 B6BF
0218 B6BF
0219 B6BF              ;-----------------------------------------------------------
0220 B6BF              ;
0221 B6BF              ; Make a control for each handle in the list.
0222 B6BF              ;
0223 B6BF 20 A8 B7     handleLoop jsr   FillTemplatePtr
0224 B6C2 B0 70                 bcs   cleanup
0225 B6C4 5A                    phy   
0226 B6C5 D4 27 D4 25           PushZLong TemplatePtr          ;template pointer is a handle so save it,
0227 B6C9 20 BC B7              jsr   LockTemplatePtr          ;..lock and dereference it
0228 B6CC 20 D2 B7              jsr   MakeControl              ;..and make the control
0229 B6CF A2 02 22 22           _HUnlock                       ;now unlock the handle using the stack
0230 B6D6 A0 94 00              ldy   #ErrorCode
0231 B6D9 B7 41                 lda   [Data],y
0232 B6DB 7A                    ply   
0233 B6DC C9 00 00              cmp   #0                       ;check for errors
0234 B6DF D0 53                 bne   cleanup
0235 B6E1 80 DC                 bra   handleLoop               ;when we are done, then goto cleanup
0236 B6E3
0237 B6E3
0238 B6E3              ;-----------------------------------------------------------
0239 B6E3              ;
0240 B6E3              ; Make a control for each resource in the list
0241 B6E3              ;
0242 B6E3 20 A8 B7     resourceLoop jsr   FillTemplatePtr      ;get the next resource ref.
0243 B6E6 B0 4C                 bcs   cleanup
0244 B6E8 5A                    phy                            ;save our index
0245 B6E9
0246 B6E9 F4 04 80              PushWord #rControlTemplate     ;Push these now for 
0247 B6EC D4 27 D4 25           PushZLong TemplatePtr          ;   ReleaseResource (below)
0248 B6F0
0249 B6F0 48 48                 PushLongSpace                  ;space for result
0250 B6F2 F4 04 80              PushWord #rControlTemplate     ;the type of resource is "CtlTemplate"
0251 B6F5 D4 27 D4 25           PushZLong TemplatePtr          ;this is the resource ref
0252 B6F9 20 9C 9D              jsr   LoadResource
0253 B6FC
0254 B6FC A3 01                 lda   1,s                      ;clone the handle into TemplatePtr
0255 B6FE 85 25                 sta   TemplatePtr
0256 B700 A3 03                 lda   3,s
0257 B702 85 27                 sta   TemplatePtr+2
0258 B704 20 BC B7              jsr   LockTemplatePtr          ;deref and lock it
0259 B707 20 D2 B7              jsr   MakeControl              ;create the control
0260 B70A A2 02 22 22           _HUnlock                       ;unlock the handle using the stack
0261 B711
0262 B711
0263 B711              ;-----------------------------------------------------------
0264 B711              ;
0265 B711              ; Release the template resource
0266 B711              ;
0267 B711 20 90 9E              jsr   ReleaseResource          ;release the resource using the stack
0268 B714
0269 B714 A0 94 00              ldy   #ErrorCode
0270 B717 B7 41                 lda   [Data],y
0271 B719
0272 B719 7A                    ply                            ;restore our index
0273 B71A C9 00 00              cmp   #0                       ;check for errors
0274 B71D D0 15                 bne   cleanup
0275 B71F 80 C2                 bra   resourceloop
0276 B721
0277 B721
0278 B721              ;-----------------------------------------------------------
0279 B721              ;
0280 B721              ; Make the single control from the pointer now in InputRef
0281 B721              ;
0282 B721 A5 4E 85 25  single   movl InputRef,TemplatePtr      ;copy the template pointer
0283 B729 20 D2 B7              jsr   MakeControl              ;create the control
0284 B72C A5 01 85 58           movl ctlHand,ResultH           ;..and save the handle to return.
0285 B734
0286 B734
0287 B734              ;-----------------------------------------------------------
0288 B734              ;
0289 B734              ; Clean every thing up.
0290 B734              ;
0291 B734              cleanup   
0292 B734 A0 91 00              ldy   #SavedHandle+1           ;check to see if we need to unlock
0293 B737 B7 41                 lda   [data],y
0294 B739 F0 3C                 beq   allDone                  ;..handle.
0295 B73B
0296 B73B A0 92 00              ldy   #SavedHandle+2           ; yup, unlock it.
0297 B73E B7 41                 lda   [data],y
0298 B740 48                    pha   
0299 B741 88                    dey   
0300 B742 88                    dey   
0301 B743 B7 41                 lda   [data],y
0302 B745 48                    pha   
0303 B746 A2 02 22 22           _HUnlock 
0304 B74D
0305 B74D A0 8C 00              ldy   #SavedRescID
0306 B750 B7 41                 lda   [data],y
0307 B752 D0 06                 bne   @ReleaseIt
0308 B754 C8                    iny   
0309 B755 C8                    iny   
0310 B756 B7 41                 lda   [data],y
0311 B758 F0 1D                 beq   allDone
0312 B75A              @ReleaseIt  
0313 B75A A5 52                 lda   InputVerb                ;Yep, so check the type of resource
0314 B75C C9 09 00              cmp   #resourceToResource      ;..(template, list) and release it.
0315 B75F F0 05                 beq   @multiple
0316 B761 F4 04 80              PushWord #rControlTemplate 
0317 B764 80 03                 bra   @single
0318 B766 F4 03 80     @multiple PushWord #rControlList 
0319 B769 A0 8E 00     @single  ldy   #SavedRescID+2
0320 B76C B7 41                 lda   [data],y
0321 B76E 48                    pha   
0322 B76F 88                    dey   
0323 B770 88                    dey   
0324 B771 B7 41                 lda   [data],y
0325 B773 48                    pha   
0326 B774 20 90 9E              jsr   ReleaseResource          ; release the single or list
0327 B777
0328 B777
0329 B777
0330 B777              allDone   
0331 B777 A0 94 00              ldy   #ErrorCode
0332 B77A B7 41                 lda   [data],y
0333 B77C A8                    tay   
0334 B77D 82 06 E9              brl   CMPop10Bytes
0335 B780
0336 B780
0337 B780              ;-----------------------------------------------------------
0338 B780              ;
0339 B780              ; Table of address of startup routines called depending on
0340 B780              ; the input ref.
0341 B780              ;
0342 B780 9C B6        startupTable DC W:ptrStartup            ;pointer to single
0343 B782 7A B6                 DC W:handStartup               ;handle to single
0344 B784 4F B6                 DC W:rescStartup               ;resource of single
0345 B786 9C B6                 DC W:ptrStartup                ;pointer to list of pointers
0346 B788 9C B6                 DC W:ptrStartup                ;pointer to list of handles
0347 B78A 9C B6                 DC W:ptrStartup                ;pointer to list of resources
0348 B78C 7A B6                 DC W:handStartup               ;handle to list of pointers
0349 B78E 7A B6                 DC W:handStartup               ;handle to list of handles
0350 B790 7A B6                 DC W:handStartup               ;handle to list of resources
0351 B792 4F B6                 DC W:rescStartup               ;resource to list of resources
0352 B794
0353 B794              ;-----------------------------------------------------------
0354 B794              ;
0355 B794              ; Table of address of action routines, called depending on
0356 B794              ; the input ref.
0357 B794              ;
0358 B794 21 B7        actionTable DC W:single                 ;pointer to single
0359 B796 21 B7                 DC W:single                    ;handle to single
0360 B798 21 B7                 DC W:single                    ;resource of single
0361 B79A A6 B6                 DC W:ptrLoop                   ;pointer to list of pointers
0362 B79C BF B6                 DC W:handleLoop                ;pointer to list of handles
0363 B79E E3 B6                 DC W:resourceLoop              ;pointer to list of resources
0364 B7A0 A6 B6                 DC W:ptrLoop                   ;handle to list of pointers
0365 B7A2 BF B6                 DC W:handleLoop                ;handle to list of handles
0366 B7A4 E3 B6                 DC W:resourceLoop              ;handle to list of resources
0367 B7A6 E3 B6                 DC W:resourceLoop              ;resource to list of resources
0368 B7A8
0369 B7A8
0370 B7A8
0371 B7A8
0372 B7A8
0373 B7A8              ;---------------------------------------------------------------
0374 B7A8              ; local routine to copy the current item from the list into
0375 B7A8              ; TemplatePtr
0376 B7A8              ;---------------------------------------------------------------
0377 B7A8 B7 4E        FillTemplatePtr lda   [InputRef],y
0378 B7AA 85 25                 sta   TemplatePtr
0379 B7AC C8                    iny   
0380 B7AD C8                    iny   
0381 B7AE B7 4E                 lda   [InputRef],y
0382 B7B0 85 27                 sta   TemplatePtr+2
0383 B7B2 C8                    iny   
0384 B7B3 C8                    iny   
0385 B7B4
0386 B7B4 05 25                 ora   TemplatePtr
0387 B7B6 F0 02                 beq   @AllDone
0388 B7B8 18                    clc   
0389 B7B9 60                    rts   
0390 B7BA
0391 B7BA 38           @AllDone sec   
0392 B7BB 60                    rts   
0393 B7BC
0394 B7BC
0395 B7BC
0396 B7BC              ;---------------------------------------------------------------
0397 B7BC              ; local routine to lock down TemplatePtr and store it back over
0398 B7BC              ; itself
0399 B7BC              ;---------------------------------------------------------------
0400 B7BC A0 04 00     LockTemplatePtr ldy   #4
0401 B7BF B7 25                 lda   [TemplatePtr],y
0402 B7C1 09 00 80              ora   #$8000
0403 B7C4 97 25                 sta   [TemplatePtr],y
0404 B7C6 88                    dey   
0405 B7C7 88                    dey   
0406 B7C8 B7 25                 lda   [TemplatePtr],y
0407 B7CA AA                    tax   
0408 B7CB A7 25                 lda   [TemplatePtr]
0409 B7CD 85 25 86 27           stax TemplatePtr
0410 B7D1 60                    rts   
0411 B7D2
0412 B7D2
0413 B7D2
0414 B7D2
0415 B7D2                       title 'MakeControl' 
0416 B7D2
0417 B7D2              ****************************************************************
0418 B7D2              *
0419 B7D2              MakeControl  
0420 B7D2              *
0421 B7D2              * Local routine that does the actual work of translating a template
0422 B7D2              * into a control - this is very similar to the old NewControl.
0423 B7D2              *
0424 B7D2              *
0425 B7D2              * Inputs:
0426 B7D2              *                   templatePtr
0427 B7D2              *                   windPtr
0428 B7D2              *
0429 B7D2              * Outputs:
0430 B7D2              *                   new control is part of list.
0431 B7D2              *
0432 B7D2              * External Refs:
0433 B7D2                       import StatTextProc 
0434 B7D2                       import PicProc 
0435 B7D2              *
0436 B7D2              * Entry Points:
0437 B7D2              *                   none
0438 B7D2              *
0439 B7D2                       longa on                       ; mode
0440 B7D2                       longi on 
0441 B7D2              *
0442 B7D2              ****************************************************************
0443 B7D2
0444 B7D2 A0 00 00              ldy   #TemplateRecord.pCount   ;check the number of parameters
0445 B7D5 B7 25                 lda   [TemplatePtr],y
0446 B7D7 C9 06 00              cmp   #minTemplatePCount
0447 B7DA B0 09                 bge   @cont
0448 B7DC A9 0A 10              lda   #TooFewParmsError
0449 B7DF A0 94 00              ldy   #ErrorCode
0450 B7E2 97 41                 sta   [data],y
0451 B7E4 60                    rts   
0452 B7E5
0453 B7E5              ;-----------------------------------------------------------
0454 B7E5              ;
0455 B7E5              ; Minimum PCount is OK.
0456 B7E5              ;
0457 B7E5              ; Look at control type, If its custom, get the pointer to
0458 B7E5              ; the custom proc into Param.  If its not custom, get
0459 B7E5              ; the ID of the standard proc into param.
0460 B7E5              ;
0461 B7E5
0462 B7E5              @cont     
0463 B7E5 A5 25                 lda   TemplatePtr
0464 B7E7 85 29                 sta   param
0465 B7E9 A5 27                 lda   TemplatePtr+2
0466 B7EB 85 2B                 sta   param+2
0467 B7ED
0468 B7ED 18                    clc                            Assume Ptr
0469 B7EE A0 14 00              ldy   #TemplateRecord.MoreFlags
0470 B7F1 B7 25                 lda   [TemplatePtr],y
0471 B7F3 29 00 10              and   #FctlProcRefNotPtr
0472 B7F6 F0 01                 beq   IsPtr
0473 B7F8 38                    sec   
0474 B7F9              IsPtr     
0475 B7F9
0476 B7F9
0477 B7F9 A0 10 00              ldy   #TemplateRecord.ProcRef+2
0478 B7FC B7 25                 lda   [TemplatePtr],y
0479 B7FE AA                    tax   
0480 B7FF 88                    dey   
0481 B800 88                    dey   
0482 B801 B7 25                 lda   [TemplatePtr],y
0483 B803 9B                    txy   
0484 B804 A2 0C 00              ldx   #recSize
0485 B807 90 05                 bcc   CallByPtr
0486 B809 20 B3 9C              jsr   CallByThisID
0487 B80C 80 03                 bra   AllocIt
0488 B80E
0489 B80E 20 A8 9C     CallByPtr jsr   CallByThisPtr
0490 B811
0491 B811              AllocIt   
0492 B811
0493 B811              ;-----------------------------------------------------------
0494 B811              ;
0495 B811              ; Temporary kludge to keep things clean!
0496 B811              ;
0497 B811
0498 B811 C9 40 00              cmp   #SuperCtlSize
0499 B814 B0 03                 bcs   @ok
0500 B816 A9 40 00              lda   #superCtlSize
0501 B819              @ok       
0502 B819
0503 B819              ;-----------------------------------------------------------
0504 B819              ;
0505 B819              ; Allocate and deref the control handle
0506 B819              ;
0507 B819
0508 B819 48                    pha                            ;save the low word of the size
0509 B81A 48 48                 PushLongSpace                  ;space for returned handle.
0510 B81C DA 48                 PushAX                         ;size returned by the defProc
0511 B81E A0 36 00              ldy   #MyID                    ;pass the ID for the control manager
0512 B821 B7 41 48              PushWord [data],y 
0513 B824 F4 00 00              PushWord #0                    ;attributes
0514 B827 48 48                 PushLongSpace                  ;space for address
0515 B829 A2 02 09 22           _NewHandle 
0516 B830 A0 94 00              ldy   #ErrorCode
0517 B833 97 41                 sta   [Data],y                 ;save the error code
0518 B835 68 85 01 68           PullLong ctlHand 
0519 B83B 90 03 82 B2           bcsl error2
0520 B840 20 E2 A1              jsr   dereference              ;ctlPtr = (ctlHand).
0521 B843 68                    pla                            ;get back the block size again.
0522 B844
0523 B844              ;-----------------------------------------------------------
0524 B844              ;
0525 B844              ; Zero the memory in the control handle
0526 B844              ;
0527 B844
0528 B844 A8                    tay                            ;Y is our index
0529 B845 4A                    lsr   a                        ;check for odd sized block
0530 B846 A9 00 00              lda   #0                       ;..and zero the block
0531 B849 90 07                 bcc   @loop0
0532 B84B E2 20                 shortm 
0533 B84D 88                    dey   
0534 B84E 97 05                 sta   [ctlPtr],y
0535 B850 C2 20                 longm 
0536 B852 88           @loop0   dey   
0537 B853 88                    dey   
0538 B854 97 05                 sta   [ctlPtr],y
0539 B856 D0 FA                 bne   @loop0
0540 B858
0541 B858              ;-----------------------------------------------------------
0542 B858              ;
0543 B858              ; The record is allocated, and zeroed. Now, hook it into 
0544 B858              ; the control list and set the fields we can set.
0545 B858              ;
0546 B858
0547 B858
0548 B858
0549 B858 A0 CA 00              ldy   #owControls              ;hook the control into the head of the
0550 B85B B7 09                 lda   [windPtr],y              ;..window's control list
0551 B85D 87 05                 sta   [ctlPtr]
0552 B85F A5 01                 lda   ctlHand
0553 B861 97 09                 sta   [windPtr],y
0554 B863 C8                    iny   
0555 B864 C8                    iny   
0556 B865 B7 09                 lda   [windPtr],y
0557 B867 AA                    tax   
0558 B868 A5 03                 lda   ctlHand+2
0559 B86A 97 09                 sta   [windPtr],y
0560 B86C A0 02 00              ldy   #2
0561 B86F 8A                    txa   
0562 B870 97 05                 sta   [ctlPtr],y
0563 B872
0564 B872              ;-----------------------------------------------------------
0565 B872              ;
0566 B872              ; Set Owner field
0567 B872              ;
0568 B872 C8                    iny   
0569 B873 C8                    iny   
0570 B874 A5 54                 lda   TheWindow
0571 B876 97 05                 sta   [<Ctlptr],y
0572 B878 C8                    iny   
0573 B879 C8                    iny   
0574 B87A A5 56                 lda   TheWindow+2
0575 B87C 97 05                 sta   [<Ctlptr],y
0576 B87E
0577 B87E
0578 B87E
0579 B87E              ;-----------------------------------------------------------
0580 B87E              ;
0581 B87E              ; Set the ID field
0582 B87E              ;
0583 B87E A0 04 00              ldy   #TemplateRecord.ID+2     ;set the control's refCon field
0584 B881 B7 25                 lda   [TemplatePtr],y
0585 B883 AA                    tax   
0586 B884 88                    dey   
0587 B885 88                    dey   
0588 B886 B7 25                 lda   [TemplatePtr],y
0589 B888 A0 38 00              ldy   #NewCtlRecord.ctlID
0590 B88B 97 05                 sta   [ctlPtr],y
0591 B88D C8                    iny   
0592 B88E C8                    iny   
0593 B88F 8A                    txa   
0594 B890 97 05                 sta   [ctlPtr],y
0595 B892
0596 B892
0597 B892
0598 B892
0599 B892              ;-----------------------------------------------------------
0600 B892              ;
0601 B892              ; Set the rectangle
0602 B892              ;
0603 B892 A0 06 00              ldy   #TemplateRecord.Rect     ;copy the rectangle into the record.
0604 B895 A2 08 00              ldx   #NewCtlRecord.ctlRect
0605 B898 B7 25        @loop1   lda   [TemplatePtr],y
0606 B89A C8                    iny   
0607 B89B C8                    iny   
0608 B89C 5A                    phy   
0609 B89D 9B                    txy   
0610 B89E 97 05                 sta   [ctlPtr],y
0611 B8A0 7A                    ply   
0612 B8A1 E8                    inx   
0613 B8A2 E8                    inx   
0614 B8A3 C0 0E 00              cpy   #TemplateRecord.Rect+8
0615 B8A6 90 F0                 blt   @loop1
0616 B8A8
0617 B8A8              ;-----------------------------------------------------------
0618 B8A8              ;
0619 B8A8              ; Set Flag
0620 B8A8              ;
0621 B8A8 A0 12 00              ldy   #TemplateRecord.Flags    ;set the control's flags and the hilite
0622 B8AB B7 25                 lda   [TemplatePtr],y          ;..field.
0623 B8AD A0 10 00              ldy   #NewCtlRecord.ctlFlag
0624 B8B0 97 05                 sta   [ctlPtr],y
0625 B8B2
0626 B8B2              ;-----------------------------------------------------------
0627 B8B2              ;
0628 B8B2              ; Set MoreFlags
0629 B8B2              ;
0630 B8B2 A0 14 00              ldy   #TemplateRecord.MoreFlags ;set the control's flags and the hilite
0631 B8B5 B7 25                 lda   [TemplatePtr],y          ;..field.
0632 B8B7 A0 3C 00              ldy   #NewCtlRecord.ctlMoreFlags
0633 B8BA 97 05                 sta   [ctlPtr],y
0634 B8BC
0635 B8BC
0636 B8BC              ;-----------------------------------------------------------
0637 B8BC              ;
0638 B8BC              ; Set the ref con
0639 B8BC              ;
0640 B8BC A0 18 00              ldy   #TemplateRecord.RefCon+2 ;set the control's refCon field
0641 B8BF B7 25                 lda   [TemplatePtr],y
0642 B8C1 AA                    tax   
0643 B8C2 88                    dey   
0644 B8C3 88                    dey   
0645 B8C4 B7 25                 lda   [TemplatePtr],y
0646 B8C6 A0 20 00              ldy   #NewCtlRecord.ctlRefCon
0647 B8C9 97 05                 sta   [ctlPtr],y
0648 B8CB C8                    iny   
0649 B8CC C8                    iny   
0650 B8CD 8A                    txa   
0651 B8CE 97 05                 sta   [ctlPtr],y
0652 B8D0
0653 B8D0
0654 B8D0
0655 B8D0
0656 B8D0              ;-----------------------------------------------------------
0657 B8D0              ;
0658 B8D0              ; Set the ctlPRoc field in the record.
0659 B8D0              ;
0660 B8D0
0661 B8D0 A0 10 00              ldy   #TemplateRecord.ProcRef+2
0662 B8D3 B7 25                 lda   [TemplatePtr],y
0663 B8D5 AA                    tax   
0664 B8D6 88                    dey   
0665 B8D7 88                    dey   
0666 B8D8 B7 25                 lda   [TemplatePtr],y
0667 B8DA
0668 B8DA A0 14 00              ldy   #NewCtlRecord.ctlProc
0669 B8DD 97 05                 sta   [ctlPtr],y
0670 B8DF C8                    iny   
0671 B8E0 C8                    iny   
0672 B8E1 8A                    txa   
0673 B8E2 09 00 80              ora   #$8000                   ;set the highest bit - indicates super
0674 B8E5 97 05                 sta   [ctlPtr],y               ;..ctl
0675 B8E7
0676 B8E7
0677 B8E7              ;-----------------------------------------------------------
0678 B8E7              ;
0679 B8E7              ; Call the init routine for the proc.
0680 B8E7              ;
0681 B8E7
0682 B8E7 A5 25                 lda   TemplatePtr              ;pass a pointer to the template for
0683 B8E9 A4 27                 ldy   TemplatePtr+2            ;..the defProc to do extra initialization
0684 B8EB A2 03 00              ldx   #initCntl
0685 B8EE 20 2B 9C              jsr   CMDispatch
0686 B8F1
0687 B8F1 60                    rts   
0688 B8F2
0689 B8F2 68           error2   pla                            ;cleanup the stack
0690 B8F3 60                    rts   
0691 B8F4
0692 B8F4
0693 B8F4
0694 B8F4                       ENDP 
0695 B8F4
0696 B8F4
0697 B8F4
0698 B8F4
0699 B8F4                       END   
